package gov.va.med.mhv.getcare.web.compare;

import java.util.Comparator;

import gov.va.med.mhv.getcare.common.dto.HealthCareProviderDTO;

public class HealthCareProviderDTOByTypeCompare implements Comparator<HealthCareProviderDTO> {

	boolean ascending = true;
	
	public HealthCareProviderDTOByTypeCompare() {		
	}

	public HealthCareProviderDTOByTypeCompare(boolean ascending) {
		this.ascending = ascending;
	}
	
	@Override
	public int compare(HealthCareProviderDTO o1, HealthCareProviderDTO o2) {
		// primary provider is first in list
		if (o1.getProviderType().equalsIgnoreCase("P")) {
			return ascending ? -1 : 1;
		}
		if (o2.getProviderType().equalsIgnoreCase("P")) {
			return ascending ? 1 : -1;
		}

		// if provider types are same, then sort by last name, first name
		// else sort by provider type
		if (o1.getProviderType().equalsIgnoreCase(o2.getProviderType())) {
			String name1 = o1.getLastName() + o1.getFirstName();
			String name2 = o2.getLastName() + o2.getFirstName();
			return name1.compareToIgnoreCase(name2);
		} else {
			return o1.getProviderType().compareToIgnoreCase(o2.getProviderType());
		}
		
	}

}
